;  ln2.asm  
;
; Compute ln(1+x), via Talor / Mcloren series
;
 .MODEL SMALL
 .DATA
xp  DQ ?
eps DQ ?
last_term DQ ?
i   DW  ?
sign DW ?
 .CODE
 .386
 .387
   ;
   ;  long double ln1x(long double x, long double eps)
   ;                     [BP+4]        [BP+14]  
   ;
   PUBLIC _ln1x
;
_ln1x	PROC	NEAR
	PUSH    BP
	MOV	BP,SP
;
        FLD   TBYTE PTR [BP+4]  ; ST = x
        FSTP   xp
        MOV sign,1               ; sign = 1
        MOV i,1                 ; n = 1
        FLD   TBYTE PTR [BP+14]  ; ST = eps
        FSTP eps
        FLDZ                  ; ln1x = 0
Do1:
        FILD sign                ; ST(1) = ln1x, ST(0) = sign
        FLD xp                  ; ST(0) = sign * xp
        FMUL
        FIDIV  i                 ; ST(0) = sign * xp / i
        FLD ST(0)
        FSTP last_term  
        FADD                    ; ST(0) = ln1x + sign *xp /i
                                ;              pop Stack
        FLD  xp                 ;
        FLD TBYTE PTR [BP+4]    ;   ST(0) = xp * x
        FMUL
        FSTP xp                 ;   xp = xp * xx
        INC  i                  ;
        NEG  sign            
        FLD eps
        FLD last_term           ; |last_term| > eps?
        FABS
        FCOMPP
        FSTSW AX
        SAHF
        JA Do1                  ; Yes, continue      
;                               ; No, return
ToRet:
        POP     BP
        RET
_ln1x  ENDP
        END
