;  ln2f.asm  
;
; Compute ln(1+x), via Talor / Mcloren series
;
 .MODEL SMALL
 .DATA
xp  DD ?
eps DD ?
last_term DD ?
i   DW  ?
sign DW ?
 .CODE
 .386
 .387
   ;
   ;  float ln1x(float x, float eps)
   ;               [BP+4]   [BP+4]  
   ;
   PUBLIC _ln1x
;
_ln1x	PROC	NEAR
	PUSH    BP
	MOV	BP,SP
;
        FLD   DWORD PTR [BP+4]  ; ST = x
        FSTP   xp
        MOV sign,1               ; sign = 1
        MOV i,1                 ; n = 1
        FLD   DWORD PTR [BP+8]  ; ST = eps
        FSTP eps
        FLDZ                  ; ln1x = 0
Do1:
        FILD sign                ; ST(1) = ln1x, ST(0) = sign
        FMUL xp                  ; ST(0) = sign * xp
        FIDIV  i                 ; ST(0) = sign * xp / i
        FST last_term  
        FADD                    ; ST(0) = ln1x + sign *xp /i
                                ;              pop Stack
        FLD  xp                 ;
        FMUL DWORD PTR [BP+4]                   ;   ST(0) = xp * x
        FSTP xp                 ;   xp = xp * xx
        INC  i                  ;
        NEG  sign            
        FLD last_term           ; |last_term| > eps?
        FABS
        FCOMP eps
        FSTSW AX
        SAHF
        JA Do1                  ; Yes, continue      
;                               ; No, return
ToRet:
        POP     BP
        RET
_ln1x  ENDP
        END
