;  ln1f.asm  
;
; Compute ln(1+x), via Talor / Mcloren series
;
 .MODEL SMALL
 .DATA
xp  DD ?
i   DW  ?
sign DW ?
 .CODE
 .386
 .387
   ;
   ;  float ln1x(float x, int n)
   ;              [BP+4]   [BP+8]  
   ;
   PUBLIC _ln1x
;
_ln1x	PROC	NEAR
	PUSH    BP
	MOV	BP,SP
;
        FLD   DWORD PTR [BP+4]  ; ST = x
        FSTP   xp
        MOV sign,1               ; sign = 1
        MOV i,1                 ; n = 1
        MOV  CX,[BP+12]
        FLDZ                  ; ln1x = 0
        JCXZ ToRet
For1:
        FILD sign                ; ST(1) = ln1x, ST(0) = sign
        FMUL xp                  ; ST(0) = sign * xp
        FIDIV  i                 ; ST(0) = sign * xp / i
        FADD                    ; ST(0) = ln1x + sign *xp /i
                                ;              pop Stack
        FLD  xp                 ;
        FMUL DWORD PTR [BP+4]                   ;   ST(0) = xp * x
        FSTP xp                 ;   xp = xp * xx
        INC  i                  ;
        NEG  sign            
        LOOP For1
;
ToRet:
        POP     BP
        RET
_ln1x  ENDP
        END
