/* fderiv2c.c - approximate derivative function */

#include <stdio.h>
#include <math.h>


extern long double approx_fderiv(long double (*f)(long double), long double x);


long double f(long double x)
{
  return x*x*x - 2.0*x*x + 3.0*x - 8.0;
} /* f */

long double real_fderiv(long double x)
{
  return 3.0*x*x - 4.0*x + 3.0;
} /* real_fderiv */


int main()
{
  printf("approx_deriv(5.0) = %Lf\n", approx_fderiv(f, 5.0));
  printf("real_fderiv(5.0) = %Lf\n", real_fderiv(5.0));

  return 0;
} /* main */
