/* fderiv2b.c - approximate derivative function */

#include <stdio.h>
#include <math.h>


extern double approx_fderiv(double (*f)(double), double x);


double f(double x)
{
  return x*x*x - 2.0*x*x + 3.0*x - 8.0;
} /* f */

double real_fderiv(double x)
{
  return 3.0*x*x - 4.0*x + 3.0;
} /* real_fderiv */


int main()
{
  printf("approx_deriv(5.0) = %lf\n", approx_fderiv(f, 5.0));
  printf("real_fderiv(5.0) = %lf\n", real_fderiv(5.0));

  return 0;
} /* main */
