/* fderiv1.c - approximate derivative function */

#include <stdio.h>
#include <math.h>


extern float approx_fderiv(float (*f)(float), float x);


float f(float x)
{
  return x*x*x - 2.0*x*x + 3.0*x - 8.0;
} /* f */

float real_fderiv(float x)
{
  return 3.0*x*x - 4.0*x + 3.0;
} /* real_fderiv */


int main()
{
  printf("approx_deriv(5.0) = %f\n", approx_fderiv(f, 5.0));
  printf("real_fderiv(5.0) = %f\n", real_fderiv(5.0));

  return 0;
} /* main */
