;
; fd2c.asm - implement numerical differentiation
;
;
;
  ASSUME CS:_TEXT, DS:_DATA
;
  ; Static Variables
_DATA SEGMENT DWORD PUBLIC 'DATA'
;
h  DT ?
two DD 2.0
fd0 DT 0.0
eps_const DT 2097152.0
eps  DT 0.0
temp DT 0.0
;
_DATA  ENDS
;
_TEXT SEGMENT BYTE PUBLIC 'CODE'
   ;
   ; long double approx_fderiv (long double (*f)(double), long  double x)
   ;                                [BP+4]                 [BP+6]   
   ;  
        .386
        .387
       PUBLIC _approx_fderiv
_approx_fderiv	PROC	NEAR
	PUSH	BP
	MOV	BP,SP
        FLD  TBYTE PTR [BP+6]
        FDIV two
        FABS 
        FSTP h  
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
        FLD     TBYTE PTR [BP+6]        
        FLD     h
        FADD
	FSTP    temp
        PUSH    DWORD PTR temp+6    ; Push x+h
        PUSH    DWORD PTR temp+2   
        PUSH    WORD PTR temp   
;        
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
        ADD     SP,10    ;  Free Parameter
        FLD     TBYTE PTR [BP+6]     
        FLD     h
        FSUB
	FSTP	temp          
        PUSH    DWORD PTR temp+6    ; Push x-h
        PUSH    DWORD PTR temp+2   
        PUSH    WORD PTR temp   
;
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
        ADD     SP,10   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FSTP fd0
        PUSH DWORD PTR [BP+12]
        PUSH DWORD PTR [BP+8]
        PUSH WORD PTR [BP+6]
        CALL WORD PTR [BP+4]
        ADD SP,10
        FLD eps_const
        FDIV
        FABS
        FSTP eps

Do1:
        FLD h
        FDIV two
        FSTP h
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
        FLD     TBYTE PTR [BP+6]        
        FLD     h
        FADD
	FSTP    temp
        PUSH    DWORD PTR temp+6    ; Push x-h
        PUSH    DWORD PTR temp+2   
        PUSH    WORD PTR temp   
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
        ADD     SP,10    ;  Free Parameter
        FLD     TBYTE PTR [BP+6]     
        FLD     h
        FSUB
	FSTP	temp          
        PUSH    DWORD PTR temp+6    ; Push x-h
        PUSH    DWORD PTR temp+2   
        PUSH    WORD PTR temp   
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
        ADD     SP,10   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FLD ST  ; ST(0) = (f(x+h)-  f(x-h))/2h, ST(1) = (f(x+h)- f(x-h))/2h
        FLD fd0  
        FSUB   ; ST(0) = current - fd0
        FABS   ;  ST(0) = | current - fd0 |
        FLD   eps
        FCOMPP
        FSTSW AX
        SAHF
        FSTP  fd0
        JNAE Do1  ; Reversed logic       
   ;
        FLD fd0
	MOV	SP,BP
	POP	BP
	RET
_approx_fderiv	ENDP
;
_TEXT ENDS
;
	END
