;
; fd2b.asm - implement numerical differentiation
;
;
  ASSUME CS:_TEXT, DS:_DATA
;
  ; Static Variables
;
_DATA SEGMENT DWORD PUBLIC 'DATA'
;
h  DQ ?
two DD 2.0
fd0 DQ 0.0
eps_const DQ 131072.0
eps  DQ 0.0
temp DQ 0.0
;
_DATA  ENDS
;
_TEXT SEGMENT BYTE PUBLIC 'CODE'
   ;
   ;    double approx_fderiv (double (*f)(double), double x)
   ;                            [BP+4]             [BP+6]   
   ;  
        .386
        .387
       PUBLIC _approx_fderiv
_approx_fderiv	PROC	NEAR
	PUSH	BP
	MOV	BP,SP
        FLD QWORD PTR [BP+6]
        FDIV two
        FABS 
        FSTP h  
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
        FLD     QWORD PTR [BP+6]        
	FADD	h
	FSTP    temp
        PUSH    DWORD PTR temp+4   ; Push x+h
        PUSH    DWORD PTR temp
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
        ADD     SP,8    ;  Free Parameter
        FLD     QWORD PTR [BP+6]     
	FSUB	h
        FSTP    temp          
        PUSH    DWORD PTR temp+4; Push x-h
        PUSH    DWORD PTR temp
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
        ADD     SP,8   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FSTP fd0
        PUSH DWORD PTR [BP+10]
        PUSH DWORD PTR [BP+6]
        CALL WORD PTR [BP+4]
        ADD SP,8
        FDIV eps_const
        FABS
        FSTP eps

Do1:
        FLD h
        FDIV two
        FSTP h
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
        FLD     QWORD PTR [BP+6]        
	FADD	h
	FSTP    temp
        PUSH    DWORD PTR temp+4   ; Push x+h
        PUSH    DWORD PTR temp
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
        ADD     SP,8    ;  Free Parameter
        FLD     QWORD PTR [BP+6]     
	FSUB	h
	FSTP	temp          
        PUSH    DWORD PTR temp+4; Push x-h
        PUSH    DWORD PTR temp
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
        ADD     SP,8   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FLD ST  ; ST(0) = (f(x+h)-  f(x-h))/2h, ST(1) = (f(x+h)- f(x-h))/2h
        FLD fd0  
        FSUB   ; ST(0) = current - fd0
        FABS   ;  ST(0) = | current - fd0 |
        FCOMP eps
        FSTSW AX
        SAHF
        FSTP  fd0
        JAE Do1         
   ;
        FLD fd0
	MOV	SP,BP
	POP	BP
	RET
_approx_fderiv	ENDP
;
_TEXT ENDS
;
	END
