;
; fd2a.asm - implement numerical differentiation
;
;
  ASSUME CS:_TEXT, DS:_DATA
;
  ; Static Variables
;
_DATA SEGMENT DWORD PUBLIC 'DATA'
h  DD ?
two DD 2.0
fd0 DD 0.0
eps_const DD 16384.0
eps  DD 0.0
temp DD 0.0
;
_DATA  ENDS
;
_TEXT SEGMENT BYTE PUBLIC 'CODE'
   ;
   ;	float approx_fderiv (float (*f)(float), float x)
   ;                            [BP+4]          [BP+6]   
   ;  
        .386
        .387
       PUBLIC _approx_fderiv
_approx_fderiv	PROC	NEAR
	PUSH	BP
	MOV	BP,SP
        FLD DWORD PTR [BP+6]
        FDIV two
        FABS 
        FSTP h  
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
	FLD	DWORD PTR [BP+6]        
	FADD	h
	FSTP    temp
	PUSH    temp               ; Push x+h
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
	ADD     SP,4    ;  Free Parameter
	FLD	DWORD PTR [BP+6]     
	FSUB	h
	FSTP	temp          
	PUSH    temp               ; Push x-h
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
	ADD     SP,4   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FSTP fd0
        PUSH DWORD PTR [BP+6]
        CALL WORD PTR [BP+4]
        ADD SP,4
        FDIV eps_const
        FABS
        FSTP eps

Do1:
        FLD h
        FDIV two
        FSTP h
   ;
   ;	  compute (*f)(x+h) -(*f)(x-h) )/ (2*h);
   ;
	FLD	DWORD PTR [BP+6]        
	FADD	h
	FSTP    temp
	PUSH    temp               ; Push x+h
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x+h)
	ADD     SP,4    ;  Free Parameter
	FLD	DWORD PTR [BP+6]     
	FSUB	h
	FSTP	temp          
	PUSH    temp               ; Push x-h
	CALL	WORD PTR [BP+4]    ; ST(0) = f(x-h), ST(1) = f(x+h)
	ADD     SP,4   ;  Free Parameter
	FSUB                   ; ST(0) =  f(x+h)-  f(x-h), ST(1) = Empty
	FLD	h      ; ST(0) = h, ST(1) = f(x+h)-  f(x-h)
	FMUL	two    ; ST(0) = 2h, ST(1) = f(x+h)-  f(x-h)
	FDIV           ; ST(0) = (f(x+h)-  f(x-h))/2h
        FLD ST  ; ST(0) = (f(x+h)-  f(x-h))/2h, ST(1) = (f(x+h)- f(x-h))/2h
        FLD fd0  
        FSUB   ; ST(0) = current - fd0
        FABS   ;  ST(0) = | current - fd0 |
        FCOMP eps
        FSTSW AX
        SAHF
        FSTP  fd0
        JAE Do1         
   ;
        FLD fd0
	MOV	SP,BP
	POP	BP
	RET
_approx_fderiv	ENDP
;
_TEXT ENDS
;
	END
