; mysleep1.asm - demonstrate Interrupt service routine
;
    .MODEL LARGE
    .STACK  100h
    .DATA
C182       DD 182065
C100       DD 10000
      ;
     .CODE
     .386
Timer_Offs DW 0
Timer_Seg DW  0
Counter   DW  0
;
; My Ctrl-Break ISR
;
Timer PROC FAR
;
     PUSHF
     CALL DWORD PTR Timer_Offs
     ;
     INC  Counter
Return:
     IRET    ;
;
Timer ENDP
;
;     
_mysleep  PROC  FAR
     PUBLIC _mysleep
     PUSH BP
     MOV  BP,SP
     PUSH ES
;
     MOV  AX,0
     MOV  ES,AX
	;
	;
;
     MOV  AX,ES:[32]         ; Preserve original ISR pointers
     MOV  Timer_Offs,AX
     MOV  AX,ES:[34]
     MOV  Timer_Seg,AX
     ;
     ; Change Timer pointers
     CLI
     MOV  WORD PTR ES:[32],OFFSET Timer
     MOV  ES:[34],CS
     STI
     MOV  AX,DS
     MOV  ES,AX
		   ;
;
;
     XOR  EAX,EAX
     MOV  AX,[BP+6]   ; Retrieve secs parameter
         ; Compute AX = secs * 18.2065 to convert to ticks
     MUL  C182    ;
     DIV  C100

     MOV  Counter,0           ; Init counter
Delay1:
     ;
     CMP  AX,Counter  ; wait n secs
     JA  Delay1
;
;  Return to caller
     ; Restore old Timer
     ;
		   ;
     MOV  AX,0
     MOV  ES,AX
     MOV  AX,Timer_Offs   ;
     CLI
     MOV  ES:[32],AX
     MOV  AX,Timer_Seg   ;
     MOV  ES:[34],AX
     STI
		   ;
     POP ES
     POP BP
     RET    ; return to caller
     ENDP _mysleep
     END 





