; multmac5.asm - demonstrate pre-compiler programming
;
    .MODEL SMALL
Int21h_ah9  MACRO  Msg
	    MOV DX,OFFSET Msg
	    MOV AH,9    ; INT 21h print-string-until-$ option
	    INT 21h     ; print the string
	   ENDM
Fast_Mult MACRO Fact
	; Efficient calculation of AX := AL * Fact
	; Implementation by SHL if Fact is power of two
	; Otherwise, ordinary mult
	; AL is assumed to contain first value
	;
  Is_power_of_two = 0
  Count  = 7                      ;  bits 0..7
  Power_of_two   = 80h
;
  REPT 7
     IF Power_of_two EQ Fact    ; Fact is a power of two
	  Is_power_of_two = 1
	  EXITM                 ; Exit  REPT
     ENDIF
     Count = Count - 1
     Power_of_two = Power_of_two / 2
  ENDM     ; End of REPT
;
; Expand NOTHING if Fact == 1 (Is_power_of_two == 1, Count == 0)
  IF (Is_power_of_two EQ 1) AND (Count NE 0)
	MOV AH,0
	SHL AX,Count
  ELSE
    IF (Is_power_of_two EQ 0)
	MOV  DL,Fact
	MUL  DL
    ENDIF
  ENDIF
ENDM             ; End of Fast_Mult
    .STACK 100h
    .DATA
Print_Str DB    ?
	  DB    ?
	  DB   '$'
      ;
     .CODE
     .386
Main:
     MOV  AX,@DATA            ; Standard Program prefix
     MOV  DS,AX               ;
	;
     MOV  AL,3
     Fast_Mult  16
     MOV  Print_Str,AL
     MOV  AL,2
     Fast_Mult 25
     MOV  Print_Str+1,AL
     Int21h_ah9  Print_Str
	  ;
Done:
     MOV  AH,4Ch              ; Set terminate option for INT 21h
     INT 21h                  ; Return to DOS (terminate program)
     END Main



   



