;  mathcmp8.asm  - Compare within the math coprocessor
;
;	int _comp( float p1, float p2)
;                   [BP+4]    [BP+8]
;
;  If p1 = p2,    Return  0
;  If p1 > p2,    Return  1
;  If p1 < p2,    Return -1
;
;FCOMP =  Compare and Pop
;Return    C3  C2  C1  C0  Meaning
;          0   0   ?   0    ST > Source
;          0   0   ?   1    ST < Source
;          1   0   ?   0    ST == Source
;          1   1   ?   1    ST is not comparable to source
;
; SAHF - Store AH into flags
;
;  Status Word
;  ------------
;  15  14   13 12 11  10    9    8    7    6    5    4     3    2   1   0
;  ---+----+--+--+--+----+----+----+----+----+----+----+----+----+----+----
; | B | C3 |  TOP   | C2 | C1 | C0 | ES | SF | PE | UE | OE | ZE | DE | IE |
;  ---+----+--+--+--+----+----+----+----+----+----+----+----+----+----+----
;
  PUBLIC _comp
;
  ASSUME CS:_TEXT
;
_TEXT    SEGMENT BYTE PUBLIC 'CODE'
 .386
 .387
_comp	PROC	NEAR  
   PUSH	  BP
   MOV	  BP,SP
   FLD      DWORD PTR [BP+4]  ;  ST(0) = p1  
   FCOMP    DWORD PTR [BP+8]  ; Compare ST with p2, pop 
   FSTSW   AX                ;  Store comparison result in AX
;
   SAHF     ; Store C3, C2, C0 in Flags register (ZF, PF, CF)
   ;
   ; Proceed as we did CMP on two unsigned integer operands
   ;
            ; Was  ST > ST(1) ( p1 > p2 ) ? 
   JBE     Not_Above       ; No, more tests
     MOV   AX,1        ; Yes, return 1
     JMP SHORT Finish
Not_Above:   ; ST <= ST(1)
          ; Was ST < ST(1) ( p1 < p2 )?
   JE  Equal                ; No, ST == ST(1)
     MOV   AX,-1        ; Yes, return 0
     JMP SHORT Finish
;
Equal:
   MOV  AX,0  ; ST == ST(1) or incomparible
;
Finish:
   POP   BP
   RET
ENDP _comp
;
_TEXT  ENDS
;
END
