;  idiv_mo3.asm - Assembler implementation of C-callable function idiv_mod.
;
;
;  Control Word
;  --------------
;  15  14  13  12  11 10  9  8  7   6    5    4    3   2    1    0
;  ---+---+---+---+--+--+--+--+---+---+----+----+----+----+----+----+
; | R | R | R | I |  RC | PC  | R | R | PM | UM | OM | ZM | DM | IM |
;  ---+---+---+---+--+--+--+--+---+---+----+----+----+----+----+----+
;
  ASSUME CS:_TEXT, DS:_DATA
;
  ; Static Variables
_DATA SEGMENT DWORD PUBLIC 'DATA'
;
Save_CW  DW ?
New_CW   DW ?
;
_DATA  ENDS
;
_TEXT SEGMENT BYTE PUBLIC 'CODE'
    .386
    .387
    ; Implementation of C callable function ...
    ;    ...  int idiv_mod(int Num, int Denom,  int *Q,  int *Rem)
    ;                      [BP+4]    [BP+6]     [BP+8]    [BP+10]
    ;  Compute Q := |_ Num / Denom _|  ,Rem := MOD(Num, Denom)
    ;  function  idiv_mod  returns 0 if Denom = 0 (illegal ..
    ;  ... division by zero), 1 otherwise
    ;
     PUBLIC _idiv_mod
_idiv_mod  PROC NEAR
     PUSH BP        ; Preserve BP
     MOV BP,SP      ; Set BP to point to Parameter area
;
     FSTCW   Save_CW          ;  Store status in Mem16
     FSTCW   New_CW            ;  Store status in Mem16
     AND  New_CW,1111001111111111B ; Erase existing RC
     OR   New_CW,0000010000000000B ; Set RC to 01 
                                   ; (Round towards  -infinity) 
     FLDCW New_CW                  ; Set New CW
;
     FILD WORD PTR [BP+6]  ; ST(0) := Denom
     FTST     ; Denom = 0 ? 
     FSTSW  AX  ; Transfer SW to AX
     SAHF     ;  Copy to flags register 
     JNZ Cont       ; Demon != 0
	   ; Yes, Denom = 0 
         FFREE ST
	 MOV AX,0    ; Return value := 0
	 JMP Done            ; Skip following code
Cont:      ; Denom != 0
     FIDIVR WORD PTR [BP+4]      ; ST = Num / ST, ST = Num / Denom 
     MOV  BX,[BP+8]      ; BX := Offset Q
     FISTP  WORD PTR [BX]       ; *Q := ST
     FILD  WORD PTR [BP+6]    ; ST = Denom
     FILD  WORD PTR [BP+4]    ; ST = Num, ST(1) = Denom
     FPREM                    ; ST = ST mod ST(1)
     MOV  BX,[BP+10]     ; BX := Offset Rem
     FISTP WORD PTR  [BX]        ; *Rem := ST
     FFREE ST            ; Free ST(0)
     MOV  AX,1   ; Ensure return value = 1
Done:
;
     FLDCW Save_CW       ; Restore control word to original value
     POP  BP             ; Restore BP register
     RET
_idiv_mod  ENDP
;
_TEXT ENDS
;
     END





