;
; CURSOR3.ASM
;
;THIS PROGRAM DEMONSTRATES CURSOR MANIPULATION.
;
;

Stak              SEGMENT PARA STACK 'STACK'
DB                 256 DUP(0)
Stak              ENDS
;
Data               SEGMENT PARA PUBLIC 'DATA'
CursorPos          DW      0     ; NUMBER OF LINES SCROLLED DOWN
Base               DW      0
Cursor_Sizes       DW      010Eh,020Eh,030Eh,040Eh,050Eh,060Eh,070Eh,080Eh
                   DW      090Eh,0A0Eh,0B0Eh,0C0Eh,0D0Eh,0C0Dh,0B0Dh,0A0Dh
                   DW      090Dh,080Dh,070Dh,060Dh,050Dh,040Dh,030Dh,020Dh
                   DW      010Dh,010Ch,020Ch,030Ch,040Ch,050Ch,060Ch,070Ch
                   DW      080Ch,090Ch,090Ch,0A0Ch,0B0Ch,0A0Bh,090Bh,080Bh
                   DW      070Bh,060Bh,050Bh,040Bh,030Bh,020Bh,010Bh,010Ah
                   DW      020Ah,030Ah,040Ah,050Ah,060Ah,070Ah,080Ah,090Ah
                   DW      0809h,0709h,0609h,0509h,0409h,0309h,0209h,0109h
                   DW      0108h,0208h,0308h,0408h,0508h,0608h,0708h,0607h
                   DW      0507h,0407h,0307h,0207h,0107h,0106h,0206h,0306h
                   DW      0406h,0506h,0405h,0305h,0205h,0105h,0104h,0204h
                   DW      0304h,0203h,0103h,0203h,0102h


;
Data               ENDS
CODE               SEGMENT PARA PUBLIC 'CODE'
                   .386  ; Enable 386 commands
SetCursorPos          PROC    NEAR
; Set Cursor to position in BX
; Input: BX
; Output: None
;
  MOV              DX,3D4H  ; POINT TO 3D4H - 3D5H PORT PAIR
  MOV              AL,14    ; ADDRESS OF CURSOR REGISTER POS HIGH BYTE
  MOV              AH,BH    ; GET DESIRED VALUE OF CURSOR POS HIGH BYTE
  OUT              DX,AX    ; PORT(3D4h) = 14, PORT(3D5h) = VALUE OF BH
;
  MOV              AL,15    ; ADDRESS OF CURSOR REGISTER POS HIGH BYTE
  MOV              AH,BL    ; GET DESIRED VALUE OF CURSOR POS LOW BYTE
  OUT              DX,AX    ; PORT(3D4h) = 15, PORT(3D5h) = VALUE OF BL
;
  RET                       ; Return to caller
SetCursorPos          ENDP
;
SetCurSize      PROC  NEAR
;
; Cursor High level assumed in AH, Low level in AL
;
;
    PUSH            AX
    MOV             DX,3D4h  ; POINT TO 3D4H - 3D5H PORT PAIR
    MOV             AL,0Ah ; CURSOR START ADDRESS (0Ah) 
    OUT             DX,AX    ; PORT(3D4h) = 0Ah, PORT(3D5h) = 01h
    POP             AX
    PUSH            AX
    MOV             AH,AL
    MOV             AL,0Bh ; CURSOR END ADDRESS -
    OUT             DX,AX    ; PORT(3D4h) = 0Bh, PORT(3D5h) = 0Eh
    POP             AX
    RET
SetCurSize        ENDP


;
START              PROC    FAR
;
;STANDARD PROGRAM PROLOGUE
;
  ASSUME           CS:CODE
  PUSH             DS          ; SAVE PSP SEGMENT ADDRESS
  MOV              AX,0
  PUSH             AX          ; SAVE RET ADDRESS OFFSET (PSP+0)
  MOV              AX,DATA
  MOV              DS,AX       ; ESTABLISH DATA SEGMENT ADDRESSABILITY
  ASSUME           DS:DATA
;
;PART1 : INITIALIZE THE DISPLAY ADAPTER
;
  MOV              AH,0          ; SELECT FUNCTION = 'SET MODE'
  MOV              AL,1          ; 40 BY 25 COLOR IMAGE
  INT              10H           ; ADAPTER INITIALIZED. PAGE 0 DISPLAYED
;
  MOV              AX,0B800H     ; SEGMENT ADDRESS OF MEMORY ON COLOR ADAPTER
;
  MOV              ES,AX         ; SET UP EXTRA SEGMENT REGISTER
  MOV              DI,0          ; INITIAL OFFSET ADDRESS INTO SEGMENT
  MOV              AL,' '        ; CHARACTER SPACE TO FILL ADAPTER MEMORY
  MOV              AH,0Eh        ; ATTRIBUTE BYTE : INTENSE YELLOW
  MOV              CX,1000       ; INITIALIZE COUNT, 1 SCREEN
  CLD                            ; WRITE FORWARD
  REP              STOSW         ; WRITE
;
; WRITE 'A' IN MID SCREEN
;
  MOV              BYTE PTR ES:[2*(12*40+20)],'A'
;
; SET THE CURSOR ADDRESS REGISTERS
;
  MOV              BX,12*40+20
  CALL             SetCursorPos
;
;PART 2 : Wait for key strike

  MOV              SI,0
NextLoop:
;

  MOV     AX,Cursor_Sizes[SI]
  CALL    SetCurSize
  ADD     SI,2
  CMP     SI,186
  JNE     Skip1
  MOV     SI,0

Skip1:


;
; Wait for key
;
  MOV              AH,0       ; WAIT AND READ KEY
  INT              16h        ;
  CMP              AH,1       ; Is it Esc?
  JE               ToReturn   ; Yes - Return to DOS
;
;  NOT ESC KEY - CHANGE CURSOR
;
  ; 3D4H  GRAPHICS ADAPTER ADDRESS REGISTER PORT
  ; 3D5H  GRAPHICS ADAPTER DATA REGISTER PORT
;
  JMP              NextLoop   ; REPEAT MAIN LOOP
;
ToReturn:
                   MOV  AX,2
                   INT  10h
                   RET
START              ENDP
CODE               ENDS
  END              START

