;  ctrlbrh1.asm  - pure assembler Ctrl-Break handler.

;

	.MODEL LARGE

	PUBLIC  _Ctrl_Break_Handler

	EXTRN   _Ctrl_Break_Flag:WORD

	EXTRN   _printf:FAR

   ;

   ;    void interrupt Ctrl_Break_Handler(void)

   ;

	.DATA

printf_str   DB 'ASM: Ctrl-Break has been pressed',10,0

	.CODE

_Ctrl_Break_Handler  PROC    FAR

	PUSH    AX            ; Preseve all registers ...

	PUSH    BX            ; ... other than FLAGS and SP.

	PUSH    CX

	PUSH    DX

	PUSH    ES

	PUSH    DS

	PUSH    SI

	PUSH    DI

	PUSH    BP

	MOV     AX,SEG _Ctrl_Break_Flag       ; Set ES to segment ...

	MOV     ES,AX                    ; ...  of Ctrl_Break_Flag

   ;

   ;       {

   ;         Ctrl_Break_Flag = 1;

   ;

	MOV     ES:[_Ctrl_Break_Flag],1      ; Set global flag to 1

   ;

   ;         printf("ASM: Ctrl-Break has been pressed\n");

   ;

	MOV     AX,SEG printf_str        ; Set DS to segment ...

	MOV     DS,AX                    ; ...  of printf_str

	PUSH    DS                       ; Store complete address

	PUSH    OFFSET printf_str        ; ... of printf_str

	CALL    _printf

	ADD     SP,4                     ; Free parameter space

   ;

   ;       }

   ;

	POP     BP       ;  Restore all registers ...

	POP     DI       ;  ... other than FLAGS and SP.

	POP     SI

	POP     DS

	POP     ES

	POP     DX

	POP     CX

	POP     BX

	POP     AX

	IRET            ; Return from interrupt

_Ctrl_Break_Handler  ENDP

	END

