;
; repparm2.asm - Echo DOS command line parameters.
;
	 .MODEL SMALL
	 .STACK  100h
	 .DATA
Parm     DB  256 DUP (?)              ; Move command line parameters here
;  Message Table:
Msg1     DB  'Value of PSP from offset 80h: ',13,10
Msg2     DB  13,10,'Value of PSP from offset 81h: ',13,10
; Error message:
ErrMsg   DB  'ERROR: Empty parameter.     '
ErrEndMarker DB 0
;
Dos_Write  MACRO BuffName, BuffSize
    ; Macro to call INT 21h with AH = 40h, BX = 1
    ; Write to stndout BuffSize chars from buffer  BuffName
    ; Input expected:
    ;    BuffName = Buffer name
    ;    BuffSize = Number of chars to print.
    ; Registers Destroyed:
    ;     AX, BX, CX, DX
    ;
     MOV DX,OFFSET BuffName         ; Set INT 21h from parameters
IFDIF <BuffSize>,<CX>               ; If BuffSize is Not CX, move ...
     MOV CX,BuffSize                ;  ... BuffSize to CX
ENDIF
     MOV AH,40h                     ; DOS write from handle function #
     MOV BX,1                       ; Standard output handle
     INT 21h                        ; Print the string
     ENDM
	 .CODE
Start:
;
; Standard program prologue except retain DS as ptr to PSP
;
ASSUME NOTHING
ASSUME CS:_TEXT
  MOV    AX,@DATA     ;   Establish extra segment addressability ...
  MOV    ES,AX        ;   ... to our data segment
ASSUME ES:_DATA
;
;  Fetch command line parameter from PSP
;
  MOV SI,80h          ; Source string offset (within PSP)
  MOV DI,OFFSET Parm  ; Destination string offset
  MOV CL,DS:[80h]     ; String length to move
  MOV CH,0
  INC CX              ; Include size byte in length consideration.
  CLD                 ; Write forward
  REP MOVSB           ; Move parm into our data area
;
; Establish normal data segment addressability
;
  MOV AX,@DATA
  MOV DS,AX
ASSUME DS:_DATA
;
;  Check for valid parameter and convert it to numeric value
;
  CMP Parm,0                    ; Is parameter length = 0 ?
  JZ Error                      ; Branch if so
;
  Dos_Write Msg1,Msg2-Msg1     ; Display Msg1
  MOV CL,Parm                  ; Move Msg length to CX
  MOV CH,0                     ;
  INC CX                       ; Include size byte in length consideration.
  Dos_Write Parm,CX            ; Display the Command-line params ...
                               ;   ... including size byte
;
  Dos_Write Msg2,Errmsg-Msg2   ; Display Msg2
  MOV CL,Parm                  ; Move Msg length to CX
  MOV CH,0                     ;
  Dos_Write Parm+1,CX          ; ; Display the Command-line params ...
                               ;   ... NOT including size byte
;
  JMP SHORT Done
;
; Display error message for invalid parameter:
;
Error:
      Dos_Write ErrMsg,ErrEndMarker-ErrMsg     ; Display Error Message
Done:
      MOV AH,4Ch
      INT 21h                  ; Return to DOS
;
     END Start

