; 
; memory4.asm - Demonstrate addressing modes
;
    .MODEL SMALL
    .STACK 100h
    .DATA
Letters  DB 'ABCDEFGHI'
DisplayString DB  20 DUP('$')
                            ;
     .CODE
Digits  DB '0123456789'
ProgStart:
     MOV AX,@DATA
     MOV DS,AX              ; Set DS to point to data segment
                            ;
     MOV DI,OFFSET DisplayString  ; Have DI point to start of ...
                                  ; ... DisplayString
     MOV AL,[Letters+2]    ; Read 'C',
     MOV [DI],AL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     MOV SI,1
     MOV BX,2
     MOV DL,[Letters+BX+SI+3]  ;  Read 'G', (Letters+6)
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     MOV SI,2
     MOV BX,1
     MOV DL,Letters[BX][SI]+3   ;  Read 'G',  (Letters+6)
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     LEA SI,Letters        ; Equivalent to "MOV SI,OFFSET Letters"
     MOV BX,2
     MOV DL,[BX+SI+1]         ;  Read 'D',  (Letters+3)
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     MOV BX,2
     MOV DL,[Digits+BX]         ; READ '2'
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     MOV BX,OFFSET Digits+3
     MOV DL,CS:[BX+1]         ; READ '4'
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
                              ;
     MOV BX,6                 ; The following CANNOT be performed by
                              ;   MOV ..., OFFSET ...
     LEA SI,Digits[BX]         ; SI := OFFSET Digits+6
     MOV AX,CS                ; ES can be written only through a register
     MOV ES,AX                ; Set ES := CS
     MOV DL,ES:[SI-1]         ; READ '5' (displacement can be negative)
     MOV [DI],DL              ; Store in DisplayString
     INC DI                   ; point to next available position
     ;
     .386                    ; Enable 386 instructions
     MOV  ESI,4              ;
     MOV  EDX,0              ;
     LEA  DX,Letters      ;
     MOV  DL,[EDX+ESI+3]     ; READ 'H' (Any choice of 2 regs for 386)
     MOV  [DI],DL            ; Store in DisplayString
     INC  DI                 ; point to next available position
                             ;
     MOV  EAX,1              ;
     MOV  EBX,2              ;
     MOV  DL,Digits[EBX+4*EAX+3]  ; READ '9' (Any choice of 2 regs for 386)
     MOV  [DI],DL              ; Store in DisplayString
     INC  DI                   ; point to next available position
                            ;
                            ;
     MOV AH,9               ; Set print option for int 21h
     MOV DX,OFFSET DisplayString  ;  Set  DS:DX to point to DisplayString
     INT 21h                ;  Print DisplayString
                            ;
     MOV AH,4Ch              ; Set terminate option for int 21h
     INT 21h                 ; Return to DOS (terminate program)
                             ;
     END  ProgStart     ; Set "ProgStart:" as first executable statement






