;  idiv_mo2.asm - Assembler implementation of C-callable function idiv_mod.
;
  ; Static Variables
   ASSUME CS:_TEXT, DS:_DATA
;
_DATA SEGMENT DWORD PUBLIC 'DATA'
; 
Half  DQ 0.4999999999999
_DATA ENDS
;    
_TEXT SEGMENT BYTE PUBLIC 'CODE'
    .386
    .387
    ; Implementation of C callable function ...
    ;    ...  int idiv_mod(int Num, int Denom,  int *Q,  int *Rem)
    ;                      [BP+4]    [BP+6]     [BP+8]    [BP+10]
    ;  Compute Q := |_ Num / Denom _|  ,Rem := MOD(Num, Denom)
    ;  function  idiv_mod  returns 0 if Denom = 0 (illegal ..
    ;  ... division by zero), 1 otherwise
    ;
     PUBLIC _idiv_mod
_idiv_mod  PROC NEAR
     PUSH BP        ; Preserve BP
     MOV BP,SP      ; Set BP to point to Parameter area
     FILD WORD PTR [BP+6]  ; ST(0) := Denom
     FTST     ; Denom = 0 ?
     FSTSW  AX ;  AX = Status word
     SAHF     ;  Copy to flags register
     JNZ Cont       ; No, continue regular operation
	   ; Yes, Denom = 0
         FFREE ST
	 MOV AX,0    ; Return value := 0
	 JMP Done            ; Skip following code
Cont:      ; Denom <> 0
     FIDIVR WORD PTR [BP+4]             ; ST = Num / ST, ST = Num / Denom
     FSUB  Half          ; Subtract 1/2 to ensure rounding down
     MOV  BX,[BP+8]      ; BX := Offset Q
     FISTP  WORD PTR [BX]       ; *Q := ST
     FILD  WORD PTR [BP+6]    ; ST = Denom
     FILD  WORD PTR [BP+4]    ; ST = Num, ST(1) = Denom
     FPREM                    ; ST = ST mod ST(1) 
     MOV  BX,[BP+10]     ; BX := Offset Rem
     FISTP WORD PTR  [BX]        ; *Rem := ST
     FFREE ST            ;
     MOV  AX,1   ; Ensure return value = 1
Done:
     POP  BP             ; Restore BP register
     RET
_idiv_mod  ENDP
;
_TEXT ENDS 
;
     END





