;
;  procs3.asm - Demonstrate use of local procedures
;
    .MODEL SMALL
    .STACK 100h
    .DATA
Max_Str_Lngth EQU 1000
PromptString DB 'Enter string:',13,10
ResultMsg DB 'The string you entered:',13,10
InputString  DB  Max_Str_Lngth  DUP (?)
InputLength DW ?
                                   ;
     .CODE
Dos_Readln  PROC  FAR
    ; CALL INT 21h with AH = 3Fh, BX = 0
    ; Read from stndin until eoln, ...
    ; ... but no more than CX chars into buffer
    ; Input expected:
    ;    DX = Buffer OFFSET
    ;    CX = Max buffer size
    ; Output:
    ;    AX = Number of chars read.
    ;
     PUSH BX                       ; Preserve service register
     MOV AH,3Fh                    ; DOS read from handle function #
     MOV BX,0                      ; Standard input handle
     INT 21h                       ; Get the string
     POP BX                        ; Restore service register
     RET
Dos_Readln  ENDP
                                   ;
                                   ;
Dos_Write  PROC  FAR
    ; CALL INT 21h with AH = 40h, BX = 1
    ; Write to stndout CX chars from buffer
    ; Input expected:
    ;    DX = Buffer OFFSET
    ;    CX = Number of chars to print.
    ;
     PUSH AX                       ; Preserve service register
     PUSH BX                       ; Preserve service register
     MOV AH,40h                    ; DOS write from handle function #
     MOV BX,1                      ; Standard output handle
     INT 21h                       ; Print the string
     POP BX                        ; Restore service register
     POP AX                        ; Restore service register
     RET
Dos_Write ENDP
                                   ;
                                   ;
Main:
     MOV AX,@DATA
     MOV DS,AX                     ; Set DS  to point to data segment
                                   ;
     MOV DX,OFFSET PromptString    ; Set DX to point to string
                                   ; Set number of chars to print
     MOV  CX,ResultMsg - PromptString
     CALL Dos_Write                ; Print the string
     MOV CX,Max_Str_Lngth          ; Read up to maximum number of chars
     MOV DX,OFFSET InputString     ; Store the string here
     CALL Dos_Readln               ;
     MOV  InputLength,AX           ; Preserve input length
                                   ;
     MOV DX,OFFSET ResultMsg       ; Set DX to point to string
                                   ; Set number of chars to print
     MOV  CX,InputString - ResultMsg
     CALL Dos_Write                ; Print the string
     MOV DX,OFFSET InputString     ; Set DX to point to string
     MOV  CX,InputLength           ; Set number of chars to print
     CALL Dos_Write                ;
                                   ;
     MOV AH,4Ch                    ; DOS terminate program function #
     INT 21h                       ; Terminate the program
     END Main







