;  mathcmp7.asm  - Compare within the math coprocessor
;
;	int _comp( float p1, float p2)
;                   [BP+4]    [BP+8]
;
;  If p1 = p2,    Return  0  
;  If p1 > p2,    Return  1
;  If p1 < p2,    Return -1  
;
;FCOMP = Compare and Pop
;Return    C3  C2  C1  C0  Meaning
;          0   0   ?   0    ST > Source
;          0   0   ?   1    ST < Source
;          1   0   ?   0    ST == Source
;          1   1   ?   1    ST is not comparable to source 
;
;TEST  = Perform Logical bitwise AND, do not change Destination oprand
;
;  Status Word
;  --------------
;  15  14   13 12 11  10    9    8    7    6    5    4     3    2   1   0
;  ---+----+--+--+--+----+----+----+----+----+----+----+----+----+----+----
; | B | C3 |  TOP   | C2 | C1 | C0 | ES | SF | PE | UE | OE | ZE | DE | IE |
;  ---+----+--+--+--+----+----+----+----+----+----+----+----+----+----+----
;
Greater_Mask EQU  0100010100000000B ; C3, C2, C0
Less_Mask    EQU  0100010000000000B ; C3, C2 
;
  PUBLIC _comp
;
  ASSUME CS:_TEXT
;
_TEXT    SEGMENT BYTE PUBLIC 'CODE'
 .386
 .387
_comp	PROC	NEAR  
   PUSH	  BP
   MOV	  BP,SP
   FLD    DWORD PTR [BP+4]  ;  ST(0) = p1
   FCOMP  DWORD PTR [BP+8]  ;  Compare ST with p2, pop 
   FSTSW   AX                ;  Store comparison result in AX
;
   TEST    AX,Greater_Mask   ; If AND yields 0, then C3 == C2 == C0 == 0
            ; Was  ST > ST(1) ( p1 > p2 ) ? 
   JNZ     Not_Greater       ; No, more tests
     MOV   AX,1        ; Yes, return 1
     JMP SHORT Finish
Not_Greater:   ; At least one of C3, C2, C1 is 1
   TEST   AX,Less_Mask ; If AND yields 0, then C3 == C2 == 0
          ; Was ST < ST(1) ( p1 < p2 )?
   JNZ  Equal
     MOV   AX,-1        ; Yes, return -1
     JMP SHORT Finish
;
Equal:
   MOV  AX,0  ; C3 (or C2) must be 1, ST == ST(1) or incomparible
;
Finish:
   POP   BP
   RET
ENDP _comp
;
_TEXT   ENDS
;
END
