/* mainint3.c - Main for pure assembler interrupt handler  */



#include <stdio.h>

#include <dos.h>



volatile int Ctrl_Break_Flag;

void interrupt (*Int27Save) (void);  /* Pointer to function */



extern void interrupt Ctrl_Break_Handler(void);



void main(void)

 {

   Int27Save = getvect(27);               /* Preserve old pointer */

   setvect(27, Ctrl_Break_Handler);

   printf("C: Press Ctrl-Break to continue.\n");



   Ctrl_Break_Flag = 0;



   while (Ctrl_Break_Flag == 0)

	  ;  /* Do nothing */



   printf("Terminating ...\n");



   setvect(27,Int27Save);               /* Restore old pointer */



 } /* main */



